/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.cim.client.HSCCltObjCache;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCCltEventQueue;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCEvent;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCEventHandler;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCIndicationErrLogger;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCSubscriptionMgr;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.cec.CECInfo;
import com.ibm.hsc.websm.cec.CECMObject;
import com.ibm.hsc.websm.frame.FrameMObject;
import com.ibm.hsc.websm.lpar.LPARInfo;
import com.ibm.hsc.websm.lpar.LPARMObject;
import com.ibm.hsc.websm.profile.ProfileInfo;
import com.ibm.hsc.websm.profile.ProfileMObject;
import com.ibm.hsc.websm.sysprofile.SysProfileInfo;
import com.ibm.hsc.websm.sysprofile.SysProfileMObject;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import com.ibm.websm.mobject.DefSysEventSupport;
import com.ibm.websm.mobject.MOClassImpl;
import com.ibm.websm.mobject.MOState;
import com.ibm.websm.mobject.MOXContainerObj;
import com.ibm.websm.mobject.MOXReference;
import com.ibm.websm.mobject.MObjectImpl;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class HscCimomListener
extends Thread
implements HSCEventHandler,
HSCIndicationErrLogger {
    private int _eventType = 0;
    private CIMInstance _sourceInst = null;
    private CIMInstance _previousInst = null;
    private Object _object = null;
    private MObjectImpl _objectImpl = null;
    private String _hostName = null;
    private String _className = null;
    private CIMObjectPath _cimPath = null;
    private MOXReference _moxRef = null;
    private String _moClassName = null;
    private static Hashtable _TIMESTAMPS = new Hashtable();
    public static final boolean DEBUG_ON = true;
    public HSCSubscriptionMgr mSubMgr = null;
    public HSCCltEventQueue mQueue = null;

    public void setSubscriptionMgr(HSCSubscriptionMgr hSCSubscriptionMgr) {
        this.mSubMgr = hSCSubscriptionMgr;
    }

    public void setEventQueue(HSCCltEventQueue hSCCltEventQueue) {
        this.mQueue = hSCCltEventQueue;
    }

    public void logException(Throwable throwable) {
        HSCLogUtils.clientLog(throwable, HSCLogUtils._IndicationClassLogInfo);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    HSCEvent hSCEvent = this.mQueue.getEvent();
                    this.eventOccured(hSCEvent, this.mSubMgr, 0);
                }
            }
            catch (Throwable throwable) {
                this.logException(throwable);
                continue;
            }
            break;
        }
    }

    public void reload() {
        block3: {
            try {
                MOClassImpl mOClassImpl = FrameMObject.getMOClassImpl((String)"com.ibm.hsc.websm.frame.FrameMObject");
                DefSysEventSupport defSysEventSupport = (DefSysEventSupport)mOClassImpl.getEventSupport();
                if (defSysEventSupport != null) {
                    defSysEventSupport.fireObjReloadMOEvent();
                }
            }
            catch (Throwable throwable) {
                if (!IDebug.enabled) break block3;
                throwable.printStackTrace();
            }
        }
    }

    public void eventOccured(HSCEvent hSCEvent, HSCSubscriptionMgr hSCSubscriptionMgr, int n) {
        CIMInstance cIMInstance = (CIMInstance)hSCEvent.getNewObject();
        CIMInstance cIMInstance2 = (CIMInstance)hSCEvent.getOldObject();
        int n2 = hSCEvent.getEventType();
        String string = hSCEvent.getObjectType();
        HSCCltObjCache hSCCltObjCache = HSCCltObjCache.getInstance();
        if (n2 == -1) {
            if (IDebug.enabled) {
                System.out.println("lost server connection");
            }
            hSCCltObjCache.cleanup();
            return;
        }
        if (n2 == -2) {
            this.reload();
            if (IDebug.enabled) {
                System.out.println("reconnected to the server. delete the gui tree");
            }
            return;
        }
        if (n2 == 2) {
            if (string.equals("IBMHSC_ComputerSystem") || string.equals("IBMHSC_Partition")) {
                hSCCltObjCache.remove(cIMInstance);
            }
        } else if ((string.equals("IBMHSC_Partition") || string.equals("IBMHSC_LparProfile") || string.equals("IBMHSC_SystemProfile")) && !hSCCltObjCache.isParentCreated(cIMInstance)) {
            if (IDebug.enabled) {
                System.out.println("skip event");
            }
            return;
        }
        this.eventOccurred(hSCEvent.getEventType(), (CIMInstance)hSCEvent.getNewObject(), (CIMInstance)hSCEvent.getOldObject(), new Long(hSCEvent.getTimestamp()));
        if (n2 == 1 && (string.equals("IBMHSC_ComputerSystem") || string.equals("IBMHSC_Partition"))) {
            hSCCltObjCache.addObject(cIMInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventOccurred(int n, CIMInstance cIMInstance, CIMInstance cIMInstance2, Object object) {
        try {
            if (IDebug.enabled) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("In eventOccurred");
                System.out.println("event type = " + n);
                System.out.println("sourceInstance = " + cIMInstance);
                System.out.println("previousInstance = " + cIMInstance2);
                System.out.println("userObject = " + object);
            }
            Trace.trace("awehhscT", " -> eventOccurred");
            Trace.trace("awehhscF", "eventType = " + n);
            Trace.trace("awehhscF", "sourceInstance = " + cIMInstance);
            Trace.trace("awehhscF", "previousInstantce = " + cIMInstance2);
            Trace.trace("awehhscF", "userObject = " + object);
            this._eventType = n;
            this._sourceInst = cIMInstance;
            this._previousInst = cIMInstance2;
            this._object = object;
            this._className = this._sourceInst.getClassName();
            if (this._eventType == 32) {
                this._displayMsg();
            }
            this._asynchOps();
            if (IDebug.enabled) {
                System.out.println("End of eventOccurred");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Trace.trace("awehhscT", "<- eventOccurred");
            throw throwable;
        }
        Trace.trace("awehhscT", "<- eventOccurred");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _asynchOps() {
        block76: {
            block75: {
                block73: {
                    block72: {
                        try {
                            try {
                                CIMProperty cIMProperty;
                                Trace.trace("awehhscT", "-> _asynchOps()");
                                if (IDebug.enabled) {
                                    System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@");
                                    System.out.println("_asynchOps");
                                }
                                this._cimPath = HscUtil.constructPath(this._sourceInst);
                                Trace.trace("awehhscF", "_cimPath = " + this._cimPath);
                                if (IDebug.enabled) {
                                    System.out.println("_cimPath = " + this._cimPath);
                                }
                                Long l = (Long)_TIMESTAMPS.get(this._cimPath);
                                Trace.trace("awehhscF", "timestamp = " + l);
                                if (l != null && l >= (Long)this._object) {
                                    if (IDebug.enabled) {
                                        System.out.println("timestamp is not newer");
                                    }
                                    Object var7_3 = null;
                                    break block72;
                                }
                                String string = null;
                                if (this._className.equals("IBMHSC_Frame")) {
                                    cIMProperty = this._sourceInst.getProperty("name");
                                    if (cIMProperty != null) {
                                        string = (String)cIMProperty.getValue().getValue();
                                    }
                                    if (IDebug.enabled) {
                                        System.out.println("Frame key = " + string);
                                    }
                                    Trace.trace("awehhscF", "key = " + string);
                                    this._moClassName = "com.ibm.hsc.websm.frame.FrameMObject";
                                    if (IDebug.enabled) {
                                        System.out.println("_moClassName = " + this._moClassName);
                                    }
                                } else if (this._className.equals("IBMHSC_ComputerSystem")) {
                                    cIMProperty = new CIMObjectPath(this._cimPath.getObjectName(), this._cimPath.getKeys());
                                    if (IDebug.enabled) {
                                        System.out.println("cimpathClone = " + cIMProperty);
                                    }
                                    string = CECInfo.getKey((CIMObjectPath)cIMProperty);
                                    if (IDebug.enabled) {
                                        System.out.println("cec key = " + string);
                                        System.out.println("cimPathClone = " + cIMProperty);
                                        System.out.println("_cimPath = " + this._cimPath);
                                    }
                                    Trace.trace("awehhscF", "key = " + string);
                                    this._moClassName = "com.ibm.hsc.websm.cec.CECMObject";
                                    if (IDebug.enabled) {
                                        System.out.println("_moClassName = " + this._moClassName);
                                    }
                                } else if (this._className.equals("IBMHSC_Partition")) {
                                    string = LPARInfo.getKey(this._cimPath);
                                    if (IDebug.enabled) {
                                        System.out.println("lpar key = " + string);
                                    }
                                    Trace.trace("awehhscF", "key = " + string);
                                    this._moClassName = "com.ibm.hsc.websm.lpar.LPARMObject";
                                    if (IDebug.enabled) {
                                        System.out.println("_moClassName = " + this._moClassName);
                                    }
                                } else if (this._className.equals("IBMHSC_LparProfile")) {
                                    string = ProfileInfo.getKey(this._cimPath);
                                    if (IDebug.enabled) {
                                        System.out.println("lpar profile key = " + string);
                                    }
                                    Trace.trace("awehhscF", "key = " + string);
                                    this._moClassName = "com.ibm.hsc.websm.profile.ProfileMObject";
                                    if (IDebug.enabled) {
                                        System.out.println("_moClassName = " + this._moClassName);
                                    }
                                } else if (this._className.equals("IBMHSC_SystemProfile")) {
                                    string = SysProfileInfo.getKey(this._cimPath);
                                    if (IDebug.enabled) {
                                        System.out.println("sys profile key = " + string);
                                    }
                                    Trace.trace("awehhscF", "key = " + string);
                                    this._moClassName = "com.ibm.hsc.websm.sysprofile.SysProfileMObject";
                                    if (IDebug.enabled) {
                                        System.out.println("_moClassName = " + this._moClassName);
                                    }
                                } else {
                                    if (!this._className.equals("IBMHSC_FrameCompSys")) {
                                        if (IDebug.enabled) {
                                            System.out.println("other than the object mentioned");
                                        }
                                        break block73;
                                    }
                                    this._cimPath = (CIMObjectPath)this._sourceInst.getProperty("PartComponent").getValue().getValue();
                                    cIMProperty = new CIMObjectPath(this._cimPath.getObjectName(), this._cimPath.getKeys());
                                    if (IDebug.enabled) {
                                        System.out.println("cimpathClone = " + cIMProperty);
                                    }
                                    string = CECInfo.getKey((CIMObjectPath)cIMProperty);
                                    if (IDebug.enabled) {
                                        System.out.println("cec key = " + string);
                                        System.out.println("cimPathClone = " + cIMProperty);
                                        System.out.println("_cimPath = " + this._cimPath);
                                    }
                                    Trace.trace("awehhscF", "key = " + string);
                                    this._moClassName = "com.ibm.hsc.websm.cec.CECMObject";
                                    if (IDebug.enabled) {
                                        System.out.println("_moClassName = " + this._moClassName);
                                    }
                                }
                                cIMProperty = null;
                                try {
                                    cIMProperty = MObjectImpl.getMOClassImpl((String)this._moClassName);
                                    if (IDebug.enabled) {
                                        System.out.println("classImpl = " + cIMProperty);
                                        System.out.println("_cimPath = " + this._cimPath);
                                    }
                                    Trace.trace("awehhscF", "classImpl = " + cIMProperty);
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                }
                                try {
                                    this._moxRef = MOClassImpl.getMOXReference((String)this._moClassName, (String)string);
                                    if (IDebug.enabled) {
                                        System.out.println("_moxRef = " + this._moxRef);
                                    }
                                    boolean bl = false;
                                    HSCCltObjCache hSCCltObjCache = HSCCltObjCache.getInstance();
                                    if ((this._className.equals("IBMHSC_Partition") || this._className.equals("IBMHSC_ComputerSystem")) && !hSCCltObjCache.isCreated(this._sourceInst)) {
                                        if (IDebug.enabled) {
                                            System.out.println("new object not exist in cache is true ");
                                        }
                                        bl = true;
                                        this._objectImpl = null;
                                    } else if (IDebug.enabled) {
                                        System.out.println("new object not exist in cache is false ");
                                    }
                                    if (IDebug.enabled) {
                                        System.out.println("objectNotExist: " + bl);
                                    }
                                    if (cIMProperty != null && !bl) {
                                        this._objectImpl = cIMProperty.getMObjectImpl(this._moxRef);
                                    }
                                    if (IDebug.enabled) {
                                        System.out.println("_objectImpl = " + this._objectImpl);
                                        System.out.println("_cimPath = " + this._cimPath);
                                    }
                                    Trace.trace("awehhscF", "_moxRef = " + this._moxRef);
                                    Trace.trace("awehhscF", "_objectImpl = " + this._objectImpl);
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                }
                                try {
                                    this._hostName = InetAddress.getLocalHost().getHostName();
                                    if (IDebug.enabled) {
                                        System.out.println("hostName = " + this._hostName);
                                        System.out.println("_cimPath = " + this._cimPath);
                                    }
                                    Trace.trace("awehhscF", "_hostName = " + this._hostName);
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                }
                                if (this._eventType == 1) {
                                    if (IDebug.enabled) {
                                        System.out.println("_cimPath = " + this._cimPath);
                                    }
                                    this._createMObject();
                                } else if (this._eventType == 2) {
                                    if (this._className.equals("IBMHSC_FrameCompSys")) {
                                        this._refreshCecMObject();
                                    } else {
                                        this._deleteMObject();
                                    }
                                } else if (this._eventType == 4) {
                                    this._modifyMObject();
                                } else if (this._eventType == 8) {
                                    this._ledValueChange();
                                } else if (this._eventType == 16) {
                                    this._createMObject();
                                } else if (this._eventType == 64) {
                                    String string2 = (String)this._sourceInst.getProperty("AsyncMsg").getValue().getValue();
                                    if (IDebug.enabled) {
                                        System.err.println("Received MANAGE ON/OFF Event");
                                        System.err.println("msg = " + string2);
                                    }
                                    if (this._className.equals("IBMHSC_ComputerSystem")) {
                                        ((CECMObject)this._objectImpl).setAsyncMessage(string2);
                                    }
                                } else {
                                    if (this._eventType != 128) break block75;
                                    if (IDebug.enabled) {
                                        System.err.println("Received MANAGE ON/OFF Event Activation");
                                    }
                                    if (this._className.equals("IBMHSC_ComputerSystem")) {
                                        ((CECMObject)this._objectImpl).showOnOffDialog();
                                    }
                                }
                                if (IDebug.enabled) {
                                    System.out.println("end of asynchOps");
                                    System.out.println("@@@@@@@@@@@@@@@@@@@@");
                                }
                                break block76;
                            }
                            catch (Throwable throwable) {
                                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                Object var7_7 = null;
                                Trace.trace("awehhscT", "<- asynchOps()");
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            Trace.trace("awehhscT", "<- asynchOps()");
                            throw throwable;
                        }
                    }
                    Trace.trace("awehhscT", "<- asynchOps()");
                    return;
                }
                Object var7_4 = null;
                Trace.trace("awehhscT", "<- asynchOps()");
                return;
            }
            Object var7_5 = null;
            Trace.trace("awehhscT", "<- asynchOps()");
            return;
        }
        Object var7_6 = null;
        Trace.trace("awehhscT", "<- asynchOps()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _refreshCecMObject() {
        try {
            block4: {
                try {
                    if (!this._className.equals("IBMHSC_FrameCompSys")) break block4;
                    CIMInstance cIMInstance = HscUtil.getCIMInstance(this._hostName, this._cimPath, false);
                    if (this._eventType != 2) break block4;
                    this._deleteCecMObject(this._moxRef, null, null);
                    this._createCecMObject(cIMInstance);
                    if (!IDebug.enabled) break block4;
                    System.out.println("delete/recreate cec mobject");
                }
                catch (Throwable throwable) {
                    HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                    Object var3_4 = null;
                    Trace.trace("awehhscT", " <- _refreshCecMObject");
                    return;
                }
            }
            Object var3_3 = null;
            Trace.trace("awehhscT", " <- _refreshCecMObject");
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            Trace.trace("awehhscT", " <- _refreshCecMObject");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _createMObject() {
        block31: {
            block29: {
                block30: {
                    block28: {
                        block27: {
                            block26: {
                                try {
                                    block24: {
                                        CIMInstance cIMInstance;
                                        block33: {
                                            block35: {
                                                block34: {
                                                    block25: {
                                                        block32: {
                                                            if (IDebug.enabled) {
                                                                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                                                                System.out.println("_createMObject()");
                                                            }
                                                            Trace.trace("awehhscT", "-> _createMObject()");
                                                            if (!this._className.equals("IBMHSC_Frame")) break block32;
                                                            CIMInstance cIMInstance2 = null;
                                                            try {
                                                                if (IDebug.enabled) {
                                                                    System.out.println("_cimPath = " + this._cimPath);
                                                                }
                                                                Trace.trace("awehhscF", "_cimPath = " + this._cimPath);
                                                                if (this._cimPath == null) {
                                                                    this._cimPath = HscUtil.constructPath(this._sourceInst);
                                                                    if (IDebug.enabled) {
                                                                        System.out.println("_cimpath = " + this._cimPath);
                                                                    }
                                                                }
                                                                cIMInstance2 = HscUtil.getCIMInstance(this._hostName, this._cimPath, false);
                                                                if (IDebug.enabled) {
                                                                    System.out.println("inst = " + cIMInstance2);
                                                                }
                                                                Trace.trace("awehhscF", "cim inst = " + cIMInstance2);
                                                            }
                                                            catch (Throwable throwable) {
                                                                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                                            }
                                                            if (cIMInstance2 == null) {
                                                                cIMInstance2 = this._sourceInst;
                                                            }
                                                            if (this._objectImpl == null) {
                                                                this._createFrameMObject(cIMInstance2);
                                                                break block24;
                                                            } else {
                                                                this._removeMObject(this._moxRef);
                                                                this._createFrameMObject(cIMInstance2);
                                                            }
                                                            break block24;
                                                        }
                                                        cIMInstance = null;
                                                        try {
                                                            cIMInstance = HscUtil.getCIMInstance(this._hostName, this._cimPath, false);
                                                            if (IDebug.enabled) {
                                                                System.out.println("In _creatMObject() --> inst = " + cIMInstance);
                                                            }
                                                            Trace.trace("awehhscF", "cim inst = " + cIMInstance);
                                                        }
                                                        catch (CIMException cIMException) {
                                                            if (cIMException.getID().equals("CIM_ERR_NOT_FOUND")) break block25;
                                                            HSCLogUtils.clientLog(cIMException, HSCLogUtils._AsyncEventClassLogInfo);
                                                        }
                                                    }
                                                    if (cIMInstance == null) {
                                                        Object var4_5 = null;
                                                        break block26;
                                                    }
                                                    if (this._objectImpl != null) break block33;
                                                    if (cIMInstance == null) {
                                                        break block27;
                                                    }
                                                    if (!this._className.equals("IBMHSC_ComputerSystem")) break block34;
                                                    this._createCecMObject(cIMInstance);
                                                    break block24;
                                                }
                                                if (!this._className.equals("IBMHSC_Partition")) break block35;
                                                this._createLparMObject(cIMInstance);
                                                break block24;
                                            }
                                            if (this._className.equals("IBMHSC_LparProfile")) {
                                                this._createLparProfileMObject(cIMInstance);
                                                break block24;
                                            } else {
                                                if (!this._className.equals("IBMHSC_SystemProfile")) break block28;
                                                this._createSysProfileMObject(cIMInstance);
                                            }
                                            break block24;
                                        }
                                        if (this._className.equals("IBMHSC_ComputerSystem")) {
                                            if (this._eventType == 16) {
                                                this._deleteCecMObject(this._moxRef, null, null);
                                                this._createCecMObject(cIMInstance);
                                            }
                                            break block29;
                                        }
                                        if (this._className.equals("IBMHSC_Partition")) {
                                            this._removeMObject(this._moxRef);
                                            this._createLparMObject(cIMInstance);
                                            break block29;
                                        }
                                        if (this._className.equals("IBMHSC_LparProfile")) {
                                            this._removeMObject(this._moxRef);
                                            this._createLparProfileMObject(cIMInstance);
                                            break block29;
                                        }
                                        if (!this._className.equals("IBMHSC_SystemProfile")) break block30;
                                        this._removeMObject(this._moxRef);
                                        this._createSysProfileMObject(cIMInstance);
                                        break block29;
                                    }
                                    if (IDebug.enabled) {
                                        System.out.println("End of _createMObject");
                                        System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                                    }
                                    break block31;
                                }
                                catch (Throwable throwable) {
                                    Object var4_11 = null;
                                    Trace.trace("awehhscT", " <- _createMObject");
                                    throw throwable;
                                }
                            }
                            Trace.trace("awehhscT", " <- _createMObject");
                            return;
                        }
                        Object var4_6 = null;
                        Trace.trace("awehhscT", " <- _createMObject");
                        return;
                    }
                    Object var4_7 = null;
                    Trace.trace("awehhscT", " <- _createMObject");
                    return;
                }
                Object var4_8 = null;
                Trace.trace("awehhscT", " <- _createMObject");
                return;
            }
            Object var4_9 = null;
            Trace.trace("awehhscT", " <- _createMObject");
            return;
        }
        Object var4_10 = null;
        Trace.trace("awehhscT", " <- _createMObject");
    }

    private void _removeMObject(MOXReference mOXReference) {
        block2: {
            try {
                MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)mOXReference.getMOClassName());
                mOClassImpl.removeMObject(mOXReference.getKey());
            }
            catch (Throwable throwable) {
                if (!IDebug.enabled) break block2;
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _deleteMObject() {
        block20: {
            block19: {
                block18: {
                    try {
                        if (IDebug.enabled) {
                            System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                            System.out.println("_deleteMObject");
                        }
                        Trace.trace("awehhscT", " -> _deleteMObject");
                        CIMInstance cIMInstance = null;
                        try {
                            cIMInstance = HscUtil.getCIMInstance(this._hostName, this._cimPath, false);
                            if (IDebug.enabled) {
                                System.out.println("inst = " + cIMInstance);
                            }
                            Trace.trace("awehhscF", "inst = " + cIMInstance);
                        }
                        catch (CIMException cIMException) {
                            if (!cIMException.getID().equals("CIM_ERR_NOT_FOUND")) {
                                HSCLogUtils.clientLog(cIMException, HSCLogUtils._AsyncEventClassLogInfo);
                            }
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                        }
                        if (cIMInstance != null) {
                            Object var5_4 = null;
                            break block18;
                        }
                        if (this._className.equals("IBMHSC_ComputerSystem")) {
                            this._deleteCecMObject(this._moxRef, null, null);
                        } else if (this._className.equals("IBMHSC_Frame")) {
                            this._deleteFrameMObject(this._moxRef);
                        } else if (this._className.equals("IBMHSC_Partition")) {
                            this._deleteLparMObject(this._moxRef);
                        } else if (this._className.equals("IBMHSC_LparProfile")) {
                            this._deleteLparProfileMObject(this._moxRef);
                        } else {
                            if (!this._className.equals("IBMHSC_SystemProfile")) break block19;
                            this._deleteSysProfileMObject(this._moxRef);
                        }
                        if (IDebug.enabled) {
                            System.out.println("End of _deleteMObject");
                            System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                        }
                        break block20;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        Trace.trace("awehhscT", " <- _deleteMObject");
                        throw throwable;
                    }
                }
                Trace.trace("awehhscT", " <- _deleteMObject");
                return;
            }
            Object var5_5 = null;
            Trace.trace("awehhscT", " <- _deleteMObject");
            return;
        }
        Object var5_6 = null;
        Trace.trace("awehhscT", " <- _deleteMObject");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _modifyMObject() {
        block50: {
            block48: {
                block43: {
                    block42: {
                        try {
                            block53: {
                                block56: {
                                    block51: {
                                        CIMInstance cIMInstance;
                                        block55: {
                                            block54: {
                                                block52: {
                                                    if (IDebug.enabled) {
                                                        System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                                                        System.out.println("_modifyMObject");
                                                    }
                                                    Trace.trace("awehhscT", " -> _modifyMObject");
                                                    if (this._objectImpl != null) break block51;
                                                    cIMInstance = null;
                                                    try {
                                                        cIMInstance = HscUtil.getCIMInstance(this._hostName, this._cimPath, false);
                                                        if (IDebug.enabled) {
                                                            System.out.println("inst = " + cIMInstance);
                                                        }
                                                        Trace.trace("awehhscF", "inst = " + cIMInstance);
                                                    }
                                                    catch (CIMException cIMException) {
                                                        if (!cIMException.getID().equals("CIM_ERR_NOT_FOUND")) {
                                                            HSCLogUtils.clientLog(cIMException, HSCLogUtils._AsyncEventClassLogInfo);
                                                        }
                                                    }
                                                    catch (Throwable throwable) {
                                                        HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                                    }
                                                    if (cIMInstance == null) {
                                                        Object var9_11 = null;
                                                        break block42;
                                                    }
                                                    if (!this._className.equals("IBMHSC_ComputerSystem")) break block52;
                                                    this._createCecMObject(cIMInstance);
                                                    break block53;
                                                }
                                                if (!this._className.equals("IBMHSC_Frame")) break block54;
                                                this._createFrameMObject(cIMInstance);
                                                break block53;
                                            }
                                            if (!this._className.equals("IBMHSC_Partition")) break block55;
                                            this._createLparMObject(cIMInstance);
                                            break block53;
                                        }
                                        if (this._className.equals("IBMHSC_LparProfile")) {
                                            this._createLparProfileMObject(cIMInstance);
                                            break block53;
                                        } else {
                                            if (!this._className.equals("IBMHSC_SystemProfile")) break block43;
                                            this._createSysProfileMObject(cIMInstance);
                                        }
                                        break block53;
                                    }
                                    Hashtable hashtable = null;
                                    Hashtable hashtable2 = null;
                                    if (!this._className.equals("IBMHSC_ComputerSystem")) break block56;
                                    hashtable = CECInfo.getAttributeValues(this._sourceInst);
                                    Trace.trace("awehhscF", "cimProperties = " + hashtable);
                                    hashtable2 = ((CECMObject)this._objectImpl).getCachedProperties();
                                    Trace.trace("awehhscF", "the mobject's properties = " + hashtable2);
                                    boolean bl = this.compareProp(hashtable, hashtable2);
                                    if (!bl) {
                                        CIMInstance cIMInstance;
                                        block44: {
                                            cIMInstance = null;
                                            try {
                                                cIMInstance = HscUtil.getCIMInstance(this._hostName, this._cimPath, false);
                                                Trace.trace("awehhscF", "cim inst = " + cIMInstance);
                                            }
                                            catch (CIMException cIMException) {
                                                if (cIMException.getID().equals("CIM_ERR_NOT_FOUND")) break block44;
                                                HSCLogUtils.clientLog(cIMException, HSCLogUtils._AsyncEventClassLogInfo);
                                            }
                                        }
                                        Hashtable hashtable3 = CECInfo.getAttributeValues(cIMInstance);
                                        Integer n = (Integer)hashtable3.get("state_PROP");
                                        if (IDebug.enabled) {
                                            System.out.println("state = " + n);
                                        }
                                        Trace.trace("awehhscF", "properties = " + hashtable3);
                                        hashtable3.put("updateCimom_PROP", Boolean.FALSE);
                                        try {
                                            ((CECMObject)this._objectImpl).setPropertyValues(hashtable3, null, null);
                                        }
                                        catch (Throwable throwable) {
                                            HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                        }
                                    }
                                    break block53;
                                }
                                if (this._className.equals("IBMHSC_Frame")) {
                                    CIMInstance cIMInstance;
                                    block45: {
                                        cIMInstance = null;
                                        try {
                                            cIMInstance = HscUtil.getCIMInstance(this._hostName, this._cimPath, false);
                                            Trace.trace("awehhscF", "cim inst = " + cIMInstance);
                                        }
                                        catch (CIMException cIMException) {
                                            if (cIMException.getID().equals("CIM_ERR_NOT_FOUND")) break block45;
                                            HSCLogUtils.clientLog(cIMException, HSCLogUtils._AsyncEventClassLogInfo);
                                        }
                                    }
                                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                                    UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMInstance.getProperty("frameType").getValue().getValue();
                                    hashtable.put("frameType_PROP", new Integer(unsignedInt16.intValue()));
                                    UnsignedInt16 unsignedInt162 = (UnsignedInt16)cIMInstance.getProperty("FrameNumber").getValue().getValue();
                                    hashtable.put("frameNumber_PROP", unsignedInt162.toString());
                                    Trace.trace("awehhscF", "properties = " + hashtable);
                                    try {
                                        ((FrameMObject)this._objectImpl).setPropertyValues(hashtable, null, null);
                                    }
                                    catch (Throwable throwable) {
                                        HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                    }
                                } else if (this._className.equals("IBMHSC_Partition")) {
                                    CIMInstance cIMInstance;
                                    block46: {
                                        cIMInstance = null;
                                        try {
                                            cIMInstance = HscUtil.getCIMInstance(this._hostName, this._cimPath, false);
                                            Trace.trace("awehhscF", "cim inst = " + cIMInstance);
                                        }
                                        catch (CIMException cIMException) {
                                            if (cIMException.getID().equals("CIM_ERR_NOT_FOUND")) break block46;
                                            HSCLogUtils.clientLog(cIMException, HSCLogUtils._AsyncEventClassLogInfo);
                                        }
                                    }
                                    Hashtable hashtable = LPARInfo.getAttributeValues(cIMInstance);
                                    Trace.trace("awehhscF", "properties = " + hashtable);
                                    hashtable.put("updateCimom_PROP", Boolean.FALSE);
                                    try {
                                        ((LPARMObject)this._objectImpl).setPropertyValues(hashtable, null, null);
                                    }
                                    catch (Throwable throwable) {
                                        HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                    }
                                } else if (this._className.equals("IBMHSC_LparProfile")) {
                                    CIMInstance cIMInstance;
                                    block47: {
                                        cIMInstance = null;
                                        try {
                                            cIMInstance = HscUtil.getCIMInstance(this._hostName, this._cimPath, false);
                                            Trace.trace("awehhscF", "cim inst = " + cIMInstance);
                                        }
                                        catch (CIMException cIMException) {
                                            if (cIMException.getID().equals("CIM_ERR_NOT_FOUND")) break block47;
                                            HSCLogUtils.clientLog(cIMException, HSCLogUtils._AsyncEventClassLogInfo);
                                        }
                                    }
                                    Hashtable hashtable = ProfileInfo.getAttributeValues(cIMInstance);
                                    Trace.trace("awehhscF", "properties = " + hashtable);
                                    Boolean bl = ProfileInfo.defaultProfile(this._hostName, this._cimPath);
                                    hashtable.put("isDefaultProfile_PROP", bl);
                                    if (bl.booleanValue()) {
                                        hashtable.put("MOState", new MOState("exp_dir", null, null, true));
                                    } else {
                                        hashtable.put("MOState", new MOState("p_folder", null, null, true));
                                    }
                                    hashtable.put("updateCimom_PROP", Boolean.FALSE);
                                    try {
                                        ((ProfileMObject)this._objectImpl).setPropertyValues(hashtable, null, null);
                                    }
                                    catch (Throwable throwable) {
                                        HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                    }
                                } else {
                                    CIMInstance cIMInstance;
                                    block49: {
                                        if (!this._className.equals("IBMHSC_SystemProfile")) break block48;
                                        cIMInstance = null;
                                        try {
                                            cIMInstance = HscUtil.getCIMInstance(this._hostName, this._cimPath, false);
                                            Trace.trace("awehhscF", "cim inst = " + cIMInstance);
                                        }
                                        catch (CIMException cIMException) {
                                            if (cIMException.getID().equals("CIM_ERR_NOT_FOUND")) break block49;
                                            HSCLogUtils.clientLog(cIMException, HSCLogUtils._AsyncEventClassLogInfo);
                                        }
                                    }
                                    Hashtable hashtable = SysProfileInfo.getAttributeValues(cIMInstance);
                                    Trace.trace("awehhscF", "properties = " + hashtable);
                                    hashtable.put("updateCimom_PROP", Boolean.FALSE);
                                    try {
                                        ((SysProfileMObject)this._objectImpl).setPropertyValues(hashtable, null, null);
                                    }
                                    catch (Throwable throwable) {
                                        HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                    }
                                }
                            }
                            if (IDebug.enabled) {
                                System.out.println("End of _modifyMObject");
                                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                            }
                            break block50;
                        }
                        catch (Throwable throwable) {
                            Object var9_15 = null;
                            Trace.trace("awehhscT", " <- _modifyMObject");
                            throw throwable;
                        }
                    }
                    Trace.trace("awehhscT", " <- _modifyMObject");
                    return;
                }
                Object var9_12 = null;
                Trace.trace("awehhscT", " <- _modifyMObject");
                return;
            }
            Object var9_13 = null;
            Trace.trace("awehhscT", " <- _modifyMObject");
            return;
        }
        Object var9_14 = null;
        Trace.trace("awehhscT", " <- _modifyMObject");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _ledValueChange() {
        block42: {
            block48: {
                block47: {
                    block46: {
                        block45: {
                            block44: {
                                try {
                                    CIMValue cIMValue;
                                    block43: {
                                        if (IDebug.enabled) {
                                            System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                                            System.out.println("In _ledValueChange()");
                                        }
                                        Trace.trace("awehhscT", " -> _ledValueChange");
                                        if (this._objectImpl == null) {
                                            if (IDebug.enabled) {
                                                System.out.println("_objectImp == null");
                                            }
                                            break block42;
                                        }
                                        cIMValue = null;
                                        try {
                                            cIMValue = HscUtil.getCIMAttribute(this._sourceInst, "OpPanelValue");
                                            if (IDebug.enabled) {
                                                System.out.println("cimOpCimValue = " + cIMValue);
                                            }
                                            Trace.trace("awehhscF", "cim inst's led value = " + cIMValue);
                                        }
                                        catch (CIMException cIMException) {
                                            if (cIMException.getID().equals("CIM_ERR_NOT_FOUND")) break block43;
                                            HSCLogUtils.clientLog(cIMException, HSCLogUtils._AsyncEventClassLogInfo);
                                        }
                                    }
                                    String string = null;
                                    String string2 = null;
                                    if (this._className.equals("IBMHSC_ComputerSystem")) {
                                        string = ((CECMObject)this._objectImpl).getOpPanelValue_PROP();
                                        if (IDebug.enabled) {
                                            System.out.println("objOpValue = " + string);
                                        }
                                        Trace.trace("awehhscF", "mobject's op value = " + string);
                                    } else if (this._className.equals("IBMHSC_Partition")) {
                                        string = ((LPARMObject)this._objectImpl).getOpPanelValue_PROP();
                                        if (IDebug.enabled) {
                                            System.out.println("objOpValue = " + string);
                                        }
                                        Trace.trace("awehhscF", "mobject's op value = " + string);
                                    } else if (this._className.equals("IBMHSC_LparProfile")) {
                                        string = ((ProfileMObject)this._objectImpl).getOpPanelValue_PROP();
                                        if (IDebug.enabled) {
                                            System.out.println("objOpValue = " + string);
                                        }
                                        Trace.trace("awehhscF", "mobject's op value = " + string);
                                    } else {
                                        if (!this._className.equals("IBMHSC_SystemProfile")) {
                                            if (IDebug.enabled) {
                                                System.out.println("nothing");
                                            }
                                            Object var8_5 = null;
                                            break block44;
                                        }
                                        if (IDebug.enabled) {
                                            System.out.println("sysProflie");
                                        }
                                    }
                                    if (cIMValue == null) {
                                        if (IDebug.enabled) {
                                            System.out.println("cimOpCimValue == null");
                                        }
                                        break block45;
                                    }
                                    string2 = (String)cIMValue.getValue();
                                    if (IDebug.enabled) {
                                        System.out.println("cimOpValue = " + string2);
                                    }
                                    Trace.trace("awehhscF", "cim inst's op value = " + string2);
                                    if (string2 == null) {
                                        break block46;
                                    }
                                    if (string2.equals("CANNOT_GET_LED")) {
                                        string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CANNOT_GET_LED", "Can not get LED");
                                    }
                                    if (string2.equals(string)) {
                                        if (IDebug.enabled) {
                                            System.out.println("same thing");
                                        }
                                        break block47;
                                    }
                                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                                    String string3 = string2.trim();
                                    if (this._className.equals("IBMHSC_ComputerSystem")) {
                                        hashtable.put("opPanelValue_PROP", string2);
                                        hashtable.put("updateCimom_PROP", Boolean.FALSE);
                                        if (IDebug.enabled) {
                                            System.out.println("prop = " + hashtable);
                                        }
                                        try {
                                            ((CECMObject)this._objectImpl).setPropertyValues(hashtable, null, null);
                                        }
                                        catch (Throwable throwable) {
                                            HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                        }
                                        break block42;
                                    }
                                    if (this._className.equals("IBMHSC_Partition")) {
                                        hashtable.put("opPanelValue_PROP", string2);
                                        hashtable.put("updateCimom_PROP", Boolean.FALSE);
                                        if (IDebug.enabled) {
                                            System.out.println("prop = " + hashtable);
                                        }
                                        try {
                                            ((LPARMObject)this._objectImpl).setPropertyValues(hashtable, null, null);
                                        }
                                        catch (Throwable throwable) {
                                            HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                        }
                                        break block42;
                                    }
                                    if (this._className.equals("IBMHSC_LparProfile")) {
                                        hashtable.put("opPanelValue_PROP", string2);
                                        hashtable.put("updateCimom_PROP", Boolean.FALSE);
                                        if (IDebug.enabled) {
                                            System.out.println("prop = " + hashtable);
                                        }
                                        try {
                                            ((ProfileMObject)this._objectImpl).setPropertyValues(hashtable, null, null);
                                        }
                                        catch (Throwable throwable) {
                                            HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                        }
                                        break block42;
                                    }
                                    if (this._className.equals("IBMHSC_SystemProfile")) {
                                        if (IDebug.enabled) {
                                            System.out.println("sysProfile");
                                        }
                                        break block42;
                                    }
                                    if (IDebug.enabled) {
                                        System.out.println("nothing");
                                    }
                                    break block48;
                                }
                                catch (Throwable throwable) {
                                    Object var8_11 = null;
                                    Trace.trace("awehhscT", " <- _ledValueChange");
                                    throw throwable;
                                }
                            }
                            Trace.trace("awehhscT", " <- _ledValueChange");
                            return;
                        }
                        Object var8_6 = null;
                        Trace.trace("awehhscT", " <- _ledValueChange");
                        return;
                    }
                    Object var8_7 = null;
                    Trace.trace("awehhscT", " <- _ledValueChange");
                    return;
                }
                Object var8_8 = null;
                Trace.trace("awehhscT", " <- _ledValueChange");
                return;
            }
            Object var8_9 = null;
            Trace.trace("awehhscT", " <- _ledValueChange");
            return;
        }
        Object var8_10 = null;
        Trace.trace("awehhscT", " <- _ledValueChange");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _rebuildChildMObject() {
        try {
            if (IDebug.enabled) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("_rebuildChildMObject()");
            }
            Trace.trace("awehhscT", "-> _rebuildChildMObject()");
            if (this._className.equals("IBMHSC_ComputerSystem")) {
                CIMInstance cIMInstance = null;
                try {
                    if (IDebug.enabled) {
                        System.out.println("_cimPath = " + this._cimPath);
                    }
                    if (this._cimPath == null) {
                        this._cimPath = HscUtil.constructPath(this._sourceInst);
                        Trace.trace("awehhscF", "_cimPath = " + this._cimPath);
                        if (IDebug.enabled) {
                            System.out.println("_cimpath = " + this._cimPath);
                        }
                    }
                    cIMInstance = HscUtil.getCIMInstance(this._hostName, this._cimPath, false);
                    if (IDebug.enabled) {
                        System.out.println("inst = " + cIMInstance);
                    }
                    Trace.trace("awehhscF", "cim inst = " + cIMInstance);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                }
                if (cIMInstance == null) {
                    cIMInstance = this._sourceInst;
                }
                if (this._objectImpl == null) {
                    this._createCecMObject(cIMInstance);
                } else {
                    this._rebuildCecChildrenMObject(this._moxRef);
                }
            }
            if (IDebug.enabled) {
                System.out.println("End of _createMObject");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Trace.trace("awehhscT", " <- _createMObject");
            throw throwable;
        }
        Trace.trace("awehhscT", " <- _createMObject");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createCecMObject(CIMInstance cIMInstance) {
        try {
            if (IDebug.enabled) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("In _createCecMObject");
            }
            Trace.trace("awehhscT", " -> _createCecMObject");
            Trace.trace("awehhscF", "Ciminstance = " + cIMInstance);
            Hashtable hashtable = CECInfo.getAttributeValues(cIMInstance);
            Trace.trace("awehhscF", "properties = " + hashtable);
            try {
                MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject");
                if (mOClassImpl != null) {
                    mOClassImpl.createNewMObject(hashtable, null);
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
        }
        finally {
            Trace.trace("awehhscT", " <- _createCecMObject");
            if (IDebug.enabled) {
                System.out.println("End of _createCecMObject");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deleteCecMObject(MOXReference mOXReference, CIMObjectPath cIMObjectPath, String string) {
        try {
            if (IDebug.enabled) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("In _deleteCecMObject");
            }
            Trace.trace("awehhscT", " -> _deleteCecMObject");
            Trace.trace("awehhscF", "MOXReference moRef = " + mOXReference);
            Trace.trace("awehhscF", "CIMObjectPath path = " + cIMObjectPath);
            Trace.trace("awehhscF", "hostName = " + string);
            try {
                CECMObject.deleteCECMObject(mOXReference);
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
        }
        finally {
            Trace.trace("awehhscT", " <- _deleteCecMObject");
            if (IDebug.enabled) {
                System.out.println("End of _deleteCecMObject");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createFrameMObject(CIMInstance cIMInstance) {
        try {
            if (IDebug.enabled) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("In _createFrameMObject");
            }
            Trace.trace("awehhscT", " -> _createFrameMObject");
            Trace.trace("awehhscF", "CIMInstance instance = " + cIMInstance);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            CIMValue cIMValue = cIMInstance.getProperty("Name").getValue();
            hashtable.put("name", (String)cIMValue.getValue());
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMInstance.getProperty("frameType").getValue().getValue();
            hashtable.put("frameType_PROP", new Integer(unsignedInt16.intValue()));
            UnsignedInt16 unsignedInt162 = (UnsignedInt16)cIMInstance.getProperty("FrameNumber").getValue().getValue();
            hashtable.put("frameNumber_PROP", unsignedInt162.toString());
            Trace.trace("awehhscF", "properties = " + hashtable);
            try {
                MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.frame.FrameMObject");
                if (mOClassImpl != null) {
                    mOClassImpl.createNewMObject(hashtable, null);
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
        }
        finally {
            Trace.trace("awehhscT", " <- _createFrameMObject");
            if (IDebug.enabled) {
                System.out.println("End of _createFrameMObject");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deleteFrameMObject(MOXReference mOXReference) {
        try {
            if (IDebug.enabled) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("In _deleteFrameMObject");
            }
            Trace.trace("awehhscT", " -> _deleteFrameMObject");
            Trace.trace("awehhscF", "MOXReference moRef = " + mOXReference);
            try {
                FrameMObject.deleteFrameMObject(mOXReference);
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
        }
        finally {
            Trace.trace("awehhscT", " <- _deleteFrameMObject");
            if (IDebug.enabled) {
                System.out.println("End of _deleteFrameMObject");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createLparMObject(CIMInstance cIMInstance) {
        try {
            if (IDebug.enabled) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("In _createLparMObject");
            }
            Trace.trace("awehhscT", " -> _createLparMObject");
            Trace.trace("awehhscF", "CIMInstance instance = " + cIMInstance);
            Hashtable hashtable = LPARInfo.getAttributeValues(cIMInstance);
            Trace.trace("awehhscF", "properties = " + hashtable);
            try {
                MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.lpar.LPARMObject");
                if (mOClassImpl != null) {
                    mOClassImpl.createNewMObject(hashtable, null);
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
        }
        finally {
            Trace.trace("awehhscT", " <- _createLparMObject");
            if (IDebug.enabled) {
                System.out.println("End of _createLparMObject");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deleteLparMObject(MOXReference mOXReference) {
        try {
            if (IDebug.enabled) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("_deleteLparMObject");
            }
            Trace.trace("awehhscT", " -> _deleteLparMObject");
            Trace.trace("awehhscF", "MOXReference moRef = " + mOXReference);
            Vector<MOXReference> vector = new Vector<MOXReference>();
            vector.add(mOXReference);
            try {
                CIMProperty cIMProperty;
                UnsignedInt8 unsignedInt8;
                short s;
                if (this._sourceInst != null && ((s = (unsignedInt8 = (UnsignedInt8)(cIMProperty = this._sourceInst.getProperty("PartitionType")).getValue().getValue()).shortValue()) == 2 || s == 3)) {
                    if (IDebug.enabled) {
                        System.out.println("try to get MObject inst");
                    }
                    String string = (String)this._sourceInst.getProperty("Name").getValue().getValue();
                    String string2 = string.substring(4);
                    try {
                        MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject");
                        MOXReference mOXReference2 = MOClassImpl.getMOXReference((String)"com.ibm.hsc.websm.cec.CECMObject", (String)string2);
                        CECMObject cECMObject = (CECMObject)mOClassImpl.getMObjectImpl(mOXReference2);
                        cECMObject.setALPARSetUpProp(false);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                    }
                }
                LPARMObject.DeleteLPARMObject(vector);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
        }
        finally {
            Trace.trace("awehhscT", " <- _deleteLparMObject");
            if (IDebug.enabled) {
                System.out.println("End of _deleteLparMObject");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createLparProfileMObject(CIMInstance cIMInstance) {
        try {
            if (IDebug.enabled) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("In _createLparProfileMObject");
            }
            Trace.trace("awehhscT", " -> _createLparProfileMObject");
            Trace.trace("awehhscF", "CIMInstance = " + cIMInstance);
            Hashtable hashtable = ProfileInfo.getAttributeValues(cIMInstance);
            Trace.trace("awehhscF", "properties = " + hashtable);
            try {
                hashtable.put("isDefaultProfile_PROP", ProfileInfo.defaultProfile(this._hostName, this._cimPath));
                MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.profile.ProfileMObject");
                if (mOClassImpl != null) {
                    mOClassImpl.createNewMObject(hashtable, null);
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
        }
        finally {
            Trace.trace("awehhscT", " <- _createLparProfileMObject");
            if (IDebug.enabled) {
                System.out.println("End of _createLparProfileMObject");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deleteLparProfileMObject(MOXReference mOXReference) {
        try {
            if (IDebug.enabled) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("In _deleteLparProfileMObject");
            }
            Trace.trace("awehhscT", " -> _deleteLparProfileMObject");
            Trace.trace("awehhscF", "MOXReference = " + mOXReference);
            MOXContainerObj mOXContainerObj = new MOXContainerObj(mOXReference);
            Trace.trace("awehhscF", "lparProfContObj = " + mOXReference);
            Vector<MOXContainerObj> vector = new Vector<MOXContainerObj>();
            vector.add(mOXContainerObj);
            Vector<MOXReference> vector2 = new Vector<MOXReference>();
            vector2.add(mOXReference);
            try {
                ProfileMObject.DeleteProfileMObject(vector2);
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
        }
        finally {
            Trace.trace("awehhscT", " <- _deleteLparProfileMObject");
            if (IDebug.enabled) {
                System.out.println("End of _deleteLparProfileMObject");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createSysProfileMObject(CIMInstance cIMInstance) {
        try {
            if (IDebug.enabled) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("In _createSysProfileMObject");
            }
            Trace.trace("awehhscT", " -> _createSysProfileMObject");
            Trace.trace("awehhscF", "CIMInstance = " + cIMInstance);
            Hashtable hashtable = SysProfileInfo.getAttributeValues(cIMInstance);
            Trace.trace("awehhscF", "properties = " + hashtable);
            try {
                MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.sysprofile.SysProfileMObject");
                if (mOClassImpl != null) {
                    mOClassImpl.createNewMObject(hashtable, null);
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
        }
        finally {
            Trace.trace("awehhscT", " <- _createSysProfileMObject");
            if (IDebug.enabled) {
                System.out.println("End of _createSysProfileMObject");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deleteSysProfileMObject(MOXReference mOXReference) {
        try {
            if (IDebug.enabled) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("In _deleteSysProfileMObject");
            }
            Trace.trace("awehhscT", " -> _deleteSysProfileMObject");
            Trace.trace("awehhscF", "MOXReference = " + mOXReference);
            Vector<MOXReference> vector = new Vector<MOXReference>();
            vector.add(mOXReference);
            try {
                SysProfileMObject.DeleteSysProfileMObject(vector);
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
        }
        finally {
            Trace.trace("awehhscT", " <- _deleteSysProfileMObject");
            if (IDebug.enabled) {
                System.out.println("End of _deleteSysProfileMObject");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _rebuildCecChildrenMObject(MOXReference mOXReference) {
        try {
            block29: {
                try {
                    String string;
                    Enumeration enumeration;
                    Trace.trace("awehhscT", "-> _rebuildCecChildrenMObject");
                    Trace.trace("awehhscF", "moRef = " + mOXReference);
                    Hashtable hashtable = null;
                    hashtable = CECMObject.getDescendants(mOXReference);
                    Trace.trace("awehhscF", "descendants = " + hashtable);
                    if (hashtable != null) {
                        enumeration = hashtable.keys();
                        while (enumeration.hasMoreElements()) {
                            string = (String)enumeration.nextElement();
                            Trace.trace("awehhscF", "key = " + string);
                            if (string.equals("SysProfileMObject")) {
                                try {
                                    SysProfileMObject.DeleteSysProfileMObject((Vector)hashtable.get(string));
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                }
                            }
                            if (!string.equals("LPARMObject")) continue;
                            try {
                                LPARMObject.DeleteLPARMObject((Vector)hashtable.get(string));
                            }
                            catch (Throwable throwable) {
                                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                            }
                        }
                    }
                    hashtable = CECMObject.getDescendants(mOXReference);
                    Trace.trace("awehhscF", "descendants = " + hashtable);
                    if (hashtable == null) break block29;
                    enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string2;
                        Object object;
                        Object object2;
                        Vector vector;
                        String string3;
                        MOXReference mOXReference2;
                        CIMObjectPath cIMObjectPath;
                        int n;
                        Vector vector2;
                        string = (String)enumeration.nextElement();
                        Trace.trace("awehhscF", "key = " + string);
                        if (string.equals("SysProfileMObject") && (vector2 = (Vector)hashtable.get(string)) != null && vector2.size() != 0) {
                            n = 0;
                            while (n < vector2.size()) {
                                try {
                                    cIMObjectPath = new CIMObjectPath("IBMHSC_SystemProfile", "root/ibmhscV3_2");
                                    mOXReference2 = (MOXReference)vector2.elementAt(n);
                                    Trace.trace("awehhscF", "sysRef = " + mOXReference2);
                                    string3 = mOXReference2.getKey();
                                    Trace.trace("awehhscF", "keyValue = " + string3);
                                    vector = HscUtil.decodeKey(string3);
                                    if (SysProfileInfo.KEY_LIST != null) {
                                        object2 = vector.elements();
                                        object = SysProfileInfo.KEY_LIST.elements();
                                        while (object.hasMoreElements()) {
                                            string2 = (String)object.nextElement();
                                            cIMObjectPath.addKey(string2, new CIMValue((Object)((String)object2.nextElement())));
                                        }
                                    }
                                    object2 = HscUtil.getCIMInstance(this._hostName, cIMObjectPath, false);
                                    Trace.trace("awehhscF", "sysProfInst = " + object2);
                                    object = SysProfileInfo.getAttributeValues((CIMInstance)object2);
                                    try {
                                        string2 = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.sysprofile.SysProfileMObject");
                                        if (string2 != null) {
                                            string2.createNewMObject(object, null);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                    }
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                }
                                ++n;
                            }
                        }
                        if (!string.equals("LPARMObject")) continue;
                        vector2 = (Vector)hashtable.get(string);
                        Trace.trace("awehhscF", "lpars = " + vector2);
                        if (vector2 == null || vector2.size() == 0) continue;
                        n = 0;
                        while (n < vector2.size()) {
                            try {
                                cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
                                mOXReference2 = (MOXReference)vector2.elementAt(n);
                                string3 = mOXReference2.getKey();
                                Trace.trace("awehhscF", "lparRef = " + mOXReference2);
                                Trace.trace("awehhscF", "keyValue = " + string3);
                                vector = HscUtil.decodeKey(string3);
                                if (LPARInfo.KEY_LIST != null) {
                                    object2 = vector.elements();
                                    object = LPARInfo.KEY_LIST.elements();
                                    while (object.hasMoreElements()) {
                                        string2 = (String)object.nextElement();
                                        cIMObjectPath.addKey(string2, new CIMValue((Object)((String)object2.nextElement())));
                                    }
                                }
                                object2 = HscUtil.getCIMInstance(this._hostName, cIMObjectPath, false);
                                Trace.trace("awehhscF", "lparInst = " + object2);
                                object = LPARInfo.getAttributeValues((CIMInstance)object2);
                                try {
                                    string2 = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.lpar.LPARMObject");
                                    if (string2 != null) {
                                        string2.createNewMObject((Hashtable)object, null);
                                    }
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                }
                            }
                            catch (Throwable throwable) {
                                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                            }
                            ++n;
                        }
                    }
                }
                catch (Throwable throwable) {
                    HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                    Object var15_22 = null;
                    Trace.trace("awehhscT", "<- rebuildCecChildrenMObject");
                    return;
                }
            }
            Object var15_21 = null;
            Trace.trace("awehhscT", "<- rebuildCecChildrenMObject");
            return;
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            Trace.trace("awehhscT", "<- rebuildCecChildrenMObject");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compareProp(Hashtable hashtable, Hashtable hashtable2) {
        boolean bl;
        block10: {
            boolean bl2;
            block11: {
                boolean bl3;
                block9: {
                    boolean bl4;
                    block8: {
                        try {
                            Object v;
                            Object v2;
                            if (IDebug.enabled) {
                                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                                System.out.println("In compareProp");
                            }
                            Trace.trace("awehhscT", "-> compareProp()");
                            Trace.trace("awehhscF", "prop1 = " + hashtable);
                            Trace.trace("awehhscF", "prop2 = " + hashtable2);
                            if (hashtable == null) {
                                bl4 = true;
                                Object var9_6 = null;
                                break block8;
                            }
                            if (hashtable2 == null) {
                                bl3 = false;
                                break block9;
                            }
                            Enumeration enumeration = hashtable.keys();
                            do {
                                if (!enumeration.hasMoreElements()) {
                                    if (IDebug.enabled) {
                                        System.out.println("End fo compareProp");
                                        System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                                    }
                                    bl = true;
                                    break block10;
                                }
                                Object k = enumeration.nextElement();
                                Trace.trace("awehhscF", "key = " + k);
                                v = hashtable.get(k);
                                v2 = hashtable2.get(k);
                                Trace.trace("awehhscF", "value1 = " + v);
                                Trace.trace("awehhscF", "value2 = " + v2);
                            } while (v2 == null || v.equals(v2));
                            bl2 = false;
                            break block11;
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            Trace.trace("awehhscT", "<- compareProp");
                            throw throwable;
                        }
                    }
                    Trace.trace("awehhscT", "<- compareProp");
                    return bl4;
                }
                Object var9_7 = null;
                Trace.trace("awehhscT", "<- compareProp");
                return bl3;
            }
            Object var9_8 = null;
            Trace.trace("awehhscT", "<- compareProp");
            return bl2;
        }
        Object var9_9 = null;
        Trace.trace("awehhscT", "<- compareProp");
        return bl;
    }

    private void _displayMsg() {
        try {
            String string = (String)this._sourceInst.getProperty("AsyncMsg").getValue().getValue();
            if (IDebug.enabled) {
                System.out.println("msg = " + string);
            }
            String string2 = "/usr/websm/bin/wsmrefresh -type self -class com.ibm.hsc.websm.managedsystem.ManagedSystemsContainer -external VimEVENT_CONDITION CUoDMsgEvent -name \"" + string + "\"";
            EExecResult eExecResult = EExec.Exec((String)string2);
            String string3 = eExecResult.stderr;
            if (string3 != null && string3.trim().length() != 0 && IDebug.enabled) {
                System.out.println("Error result = " + string3);
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
        }
    }

    private void _manageOnOffCoD() {
        try {
            String string = (String)this._sourceInst.getProperty("AsyncMsg").getValue().getValue();
            if (IDebug.enabled) {
                System.out.println("msg = " + string);
            }
            String string2 = "/usr/websm/bin/wsmrefresh -type self -class com.ibm.hsc.auiml.databeans.cec.ManageOnOffCoDProcessorBean -external VimEVENT_CONDITION OnOffMsgEvent -name \"" + string + "\"";
            EExecResult eExecResult = EExec.Exec((String)string2);
            String string3 = eExecResult.stderr;
            if (string3 != null && string3.trim().length() != 0 && IDebug.enabled) {
                System.out.println("Error result = " + string3);
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
        }
    }
}

